<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row withdraw-all-row">

            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('User')); ?></th>
                                        <th><?php echo e(__('Withdraw Amount')); ?></th>
                                        <th><?php echo e(__('User Will Get')); ?></th>
                                        
                                        <th><?php echo e(__('Charge')); ?></th>
                                        <th><?php echo e(__('status')); ?></th>
                                        <th><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $withdrawlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $withdrawlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>

                                                <a href="<?php echo e(route('admin.user.details', $withdrawlog->user->id)); ?>" >
                                                    <span class="ml-2">
                                                        <?php echo e($withdrawlog->user->username); ?>

                                                    </span>
                                                </a>

                                            </td>

                                            
                                            <td>
                                                <?php echo e(showAmount($withdrawlog->withdraw_amount)); ?> <?php echo e(@$general->site_currency); ?>

                                            </td>
                                            <td>
                                                <?php echo e(showAmount($withdrawlog->withdraw_amount - $withdrawlog->withdraw_charge)); ?> <?php echo e(@$general->site_currency); ?>

                                            </td>
                                            
                                            <td>
                                                <?php echo e(number_format($withdrawlog->withdraw_charge, 2)); ?> <?php echo e(@$general->site_currency); ?>

                                            </td>
                                            <td>
                                                <?php if($withdrawlog->status == 1): ?>
                                                    <span class="badge badge-success"><?php echo e(__('Success')); ?></span>
                                                <?php elseif($withdrawlog->status == 2): ?>
                                                    <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-warning"><?php echo e(__('Pending')); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <button class="btn btn-md btn-info details"
                                                    data-user_data="<?php echo e(json_encode($withdrawlog->user_withdraw_prof)); ?>"
                                                    data-transaction="<?php echo e($withdrawlog->transaction_id); ?>"
                                                    data-amount="<?php echo e($withdrawlog->withdraw_amount); ?>"
                                                    data-charge="<?php echo e($withdrawlog->withdraw_charge); ?>"
                                                    data-payment_details_lebel="<?php echo e($withdrawlog->withdrawMethod->payment_details_lebel); ?>"
                                                    data-singel_currency="<?php echo e($withdrawlog->withdrawMethod->singel_currency); ?>"
                                                    data-singel_rate="<?php echo e($withdrawlog->withdrawMethod->singel_rate); ?>"
                                                    data-provider="<?php echo e($withdrawlog->user->fullname); ?>"
                                                    data-username="<?php echo e($withdrawlog->user->username); ?>"
                                                    data-user="<?php echo e($withdrawlog->user); ?>"
                                                    data-informations="<?php echo e($withdrawlog->informations); ?>"
                                                    data-email="<?php echo e($withdrawlog->user->email); ?>"
                                                    data-method_name="<?php echo e($withdrawlog->withdrawMethod->name); ?>"
                                                    data-date="<?php echo e(__($withdrawlog->created_at->format('d F Y'))); ?>"><?php echo e(__('Details')); ?></button>
                                                <?php if($withdrawlog->status == 0): ?>
                                                    <button class="btn btn-md btn-primary accept"
                                                        data-url="<?php echo e(route('admin.withdraw.accept', $withdrawlog)); ?>"><?php echo e(__('Accept')); ?></button>
                                                    <button class="btn btn-md btn-danger reject"
                                                        data-url="<?php echo e(route('admin.withdraw.reject', $withdrawlog)); ?>"><?php echo e(__('Reject')); ?></button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($withdrawlogs->hasPages()): ?>
                        <?php echo e($withdrawlogs->links('backend.partial.paginate')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal -->
    <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">


            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Withdraw Details')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid withdraw-details">

                    </div>
                    <div class="container-fluid withdraw-infos mt-3">


                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('Close')); ?></button>

                </div>
            </div>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="accept" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">

            <form action="" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Withdraw Accept')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">
                            <p><?php echo e(__('Are you sure to Accept this withdraw request')); ?>?</p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Accept')); ?></button>

                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="reject" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">

            <form action="" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Withdraw Reject')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">
                            <div class="form-group col-md-12">

                                <label for=""><?php echo e(__('Reason Of Reject')); ?></label>
                                <textarea name="reason_of_reject" id="" cols="30" rows="10" class="form-control"> </textarea>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo e(__('Reject')); ?></button>

                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .image-rounded{
            width: 50px;
            height: 50px;
        }
    </style>
<?php $__env->stopPush(); ?>




<?php $__env->startPush('script'); ?>
    <script>
        $(function() {
            'use strict'

            $('.details').on('click', function() {
                const modal = $('#details');

                let html = `

                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo e(__('Withdraw Amount')); ?>

                            <span>${ Number.parseFloat($(this).data('amount')).toFixed(2) } <?php echo e(@$general->site_currency); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo e(__('User Will Get')); ?>

                            <span>${ Number.parseFloat( ($(this).data('amount') - $(this).data('charge')) * $(this).data('singel_rate')).toFixed(2) } ${$(this).data('singel_currency')}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo e(__('Transaction Id')); ?>

                            <span>${$(this).data('transaction')}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo e(__('Username')); ?>

                            <span>${$(this).data('username')}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo e(__('Withdraw Date')); ?>

                            <span>${$(this).data('date')}</span>
                        </li>
                    </ul>


                `;

                modal.find('.withdraw-details').html(html);

                let informations = $(this).data('informations');
                let infos = '';
                // console.log(informations);

                // $.each(informations, function (index, value) {
                //     infos += `
                //         <li class="list-group-item">${cap1stLeter(index.replace('_', " "))} : ${value}</li>
                //     `;
                // });

                // if (infos) {
                //     $('.withdraw-infos').html(`

                //         <h6 class="mb-3 text-center">
                //             Informations
                //         </h6>
                //         <ul class="list-group">
                //             ${infos}
                //         </ul>

                //     `);
                // } else {
                //     $('.withdraw-infos').html(``);
                // }

                let walletInfo = '';
                let thisUser = $(this).data('user');
                let singel_currency = $(this).data('singel_currency');
                    singel_currency = singel_currency.toLowerCase();

                if (singel_currency == 'usdt' && thisUser.usdt_wallet_address) {
                    walletInfo = `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Gateway <span>${$(this).data('method_name')}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            USDT Wallet Address <span>${thisUser.usdt_wallet_address}</span>
                        </li>
                    `;
                } else if (singel_currency != 'usdt' && thisUser.bdt_wallet_number) {
                    walletInfo = `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Gateway <span>${$(this).data('method_name')}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Wallet Address <span>${thisUser.bdt_wallet_number}</span>
                        </li>
                    `;
                }

                if (walletInfo) {
                    $('.withdraw-infos').html(`

                        <h6 class="mb-3 text-center">
                            Informations
                        </h6>
                        <ul class="list-group">
                            ${walletInfo}
                        </ul>

                    `);
                } else {
                    $('.withdraw-infos').html(``);
                }

                modal.modal('show');
            })

            $('.accept').on('click', function() {
                const modal = $('#accept');

                modal.find('form').attr('action', $(this).data('url'));
                modal.modal('show');
            })

            $('.reject').on('click', function() {
                const modal = $('#reject');

                modal.find('form').attr('action', $(this).data('url'));
                modal.modal('show');
            })

        })

        //cap 1st leter
        const cap1stLeter = (string) => {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/skynettr/public_html/expressprofiit.us/core/resources/views/backend/withdraw/withdraw_all.blade.php ENDPATH**/ ?>